/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.base.data.recipe;

import com.railwayteam.railways.Railways;
import com.railwayteam.railways.base.data.recipe.RailwaysRecipeProvider;
import com.railwayteam.railways.base.data.recipe.forge.RailwaysSequencedAssemblyRecipeGenImpl;
import com.railwayteam.railways.registry.CRItems;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.railwayteam.railways.track_api.TrackMaterial;
import com.railwayteam.railways.util.TextUtils;
import com.simibubi.create.content.contraptions.components.deployer.DeployerApplicationRecipe;
import com.simibubi.create.content.contraptions.components.press.PressingRecipe;
import com.simibubi.create.content.contraptions.components.saw.CuttingRecipe;
import com.simibubi.create.content.contraptions.itemAssembly.SequencedAssemblyRecipeBuilder;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.UnaryOperator;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public abstract class RailwaysSequencedAssemblyRecipeGen
extends RailwaysRecipeProvider {
    final EnumMap<DyeColor, RailwaysRecipeProvider.GeneratedRecipe> CONDUCTOR_CAPS = new EnumMap(DyeColor.class);
    final Map<TrackMaterial, RailwaysRecipeProvider.GeneratedRecipe> TRACKS = new HashMap<TrackMaterial, RailwaysRecipeProvider.GeneratedRecipe>();

    protected RailwaysSequencedAssemblyRecipeGen(DataGenerator pGenerator) {
        super(pGenerator);
        for (DyeColor dyeColor : DyeColor.values()) {
            String colorName = TextUtils.titleCaseConversion(dyeColor.m_41065_().replace("_", " "));
            String colorReg = dyeColor.m_41065_().toLowerCase(Locale.ROOT);
            this.CONDUCTOR_CAPS.put(dyeColor, this.create(colorReg + "_conductor_cap", b -> b.require((ItemLike)CRItems.woolByColor(color)).transitionTo((ItemLike)CRItems.ITEM_INCOMPLETE_CONDUCTOR_CAP.get(color).get()).addOutput((ItemLike)CRItems.ITEM_CONDUCTOR_CAP.get(color).get(), 1.0f).loops(1).addStep(CuttingRecipe::new, rb -> rb).addStep(DeployerApplicationRecipe::new, rb -> rb.require(RailwaysRecipeProvider.Ingredients.precisionMechanism())).addStep(DeployerApplicationRecipe::new, rb -> rb.require(RailwaysRecipeProvider.Ingredients.string()))));
        }
        for (TrackMaterial trackMaterial : TrackMaterial.allCustom("railways")) {
            if (trackMaterial.railsIngredient.m_43947_() || trackMaterial.sleeperIngredient.m_43947_()) continue;
            this.TRACKS.put(trackMaterial, this.create("track_" + trackMaterial.resName(), b -> b.require(material.sleeperIngredient).transitionTo((ItemLike)CRItems.ITEM_INCOMPLETE_TRACK.get(trackMaterial).get()).addOutput((ItemLike)trackMaterial.getTrackBlock().get(), 1.0f).loops(1).addStep(DeployerApplicationRecipe::new, rb -> rb.require(material.railsIngredient)).addStep(DeployerApplicationRecipe::new, rb -> rb.require(material.railsIngredient)).addStep(PressingRecipe::new, rb -> rb)));
        }
        this.TRACKS.put(CRTrackMaterials.MONORAIL, this.create("track_monorail", b -> b.require(RailwaysRecipeProvider.Ingredients.girder()).transitionTo((ItemLike)CRItems.ITEM_INCOMPLETE_TRACK.get(CRTrackMaterials.MONORAIL).get()).addOutput(new ItemStack((ItemLike)CRTrackMaterials.MONORAIL.getTrackBlock().get(), 6), 1.0f).loops(1).addStep(DeployerApplicationRecipe::new, rb -> rb.require(RailwaysRecipeProvider.Ingredients.metalBracket())).addStep(DeployerApplicationRecipe::new, rb -> rb.require(RailwaysRecipeProvider.Ingredients.ironSheet())).addStep(PressingRecipe::new, rb -> rb)));
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static RecipeProvider create(DataGenerator gen) {
        return RailwaysSequencedAssemblyRecipeGenImpl.create(gen);
    }

    protected RailwaysRecipeProvider.GeneratedRecipe create(String name, UnaryOperator<SequencedAssemblyRecipeBuilder> transform) {
        RailwaysRecipeProvider.GeneratedRecipe generatedRecipe = c -> ((SequencedAssemblyRecipeBuilder)transform.apply(new SequencedAssemblyRecipeBuilder(Railways.asResource(name)))).build(c);
        this.all.add(generatedRecipe);
        return generatedRecipe;
    }

    @NotNull
    public String m_6055_() {
        return "Railways' Sequenced Assembly Recipes";
    }
}

